package data.missions.conflictofinterest;

import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition implements MissionDefinitionPlugin {

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "ISA", FleetGoal.ATTACK, false, 4);
        api.initFleet(FleetSide.ENEMY, "BRS", FleetGoal.ATTACK, true, 1);

        api.setFleetTagline(FleetSide.PLAYER, "Remaining elements of Imperial Fleet VII");
        api.setFleetTagline(FleetSide.ENEMY, "Blackrock Observation Fleet");

        if (!SWPModPlugin.imperiumExists) {
            api.addBriefingItem("INTERSTELLAR IMPERIUM REQUIRED");
            api.addBriefingItem("Download Interstellar Imperium to play this mission!");
        }

        if (!SWPModPlugin.blackrockExists) {
            api.addBriefingItem("BLACKROCK DRIVE YARDS REQUIRED");
            api.addBriefingItem("Download Blackrock Drive Yards to play this mission!");
        }

        if (!SWPModPlugin.blackrockExists || !SWPModPlugin.imperiumExists) {
            return;
        } else {
            api.addBriefingItem("Defeat the enemy fleet.");
            api.addBriefingItem(
                    "The commander of Fleet VII is highly decorated; your ships are particularly effective in battle.");
        }

        PersonAPI captain = api.addToFleet(FleetSide.PLAYER, "ii_eagle_i_eli", FleetMemberType.SHIP, "ISA Gilgamesh",
                                           true).getCaptain();
        captain.getStats().setAptitudeLevel("combat", 2);
        captain.getStats().setSkillLevel("missile_specialization", 2);
        captain.getStats().setSkillLevel("ordnance_expert", 2);
        captain.getStats().setSkillLevel("damage_control", 2);
        captain.getStats().setSkillLevel("target_analysis", 2);
        captain.getStats().setSkillLevel("evasive_action", 2);
        captain.getStats().setSkillLevel("helmsmanship", 2);

        api.addToFleet(FleetSide.PLAYER, "ii_sebastos_ig_imp", FleetMemberType.SHIP, "ISA Enkidu", false);
        api.addToFleet(FleetSide.PLAYER, "ii_interrex_eli", FleetMemberType.SHIP, "ISA Law", false);
        api.addToFleet(FleetSide.PLAYER, "ii_interrex_eli", FleetMemberType.SHIP, "ISA Order", false);
        api.addToFleet(FleetSide.PLAYER, "ii_princeps_art", FleetMemberType.SHIP, "ISA Stationery", false);
        api.addToFleet(FleetSide.PLAYER, "ii_decurion_ig_imp", FleetMemberType.SHIP, "ISA Carbine", false);
        api.addToFleet(FleetSide.PLAYER, "ii_decurion_ig_imp", FleetMemberType.SHIP, "ISA Rifle", false);
        api.addToFleet(FleetSide.PLAYER, "ii_basileus_sta", FleetMemberType.SHIP, "ISA Hellfire", false);
        api.addToFleet(FleetSide.PLAYER, "ii_basileus_sta", FleetMemberType.SHIP, "ISA Tomahawk", false);

        api.addToFleet(FleetSide.ENEMY, "brdy_stenos_exploration", FleetMemberType.SHIP, "BRS Harbinger of Death", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_knight_elite", FleetMemberType.SHIP, "BRS Supernova", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_convergence_standard", FleetMemberType.SHIP, "BRS Hespith", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_scorpion_standard", FleetMemberType.SHIP, "BRS Jambalaya", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_scorpion_standard", FleetMemberType.SHIP, "BRS Gumbo", false);
        api.addToFleet(FleetSide.ENEMY, "gonodactylus_assault", FleetMemberType.SHIP, "BRS Shrimp", false);
        api.addToFleet(FleetSide.ENEMY, "gonodactylus_assault", FleetMemberType.SHIP, "BRS Prawn", false);
        api.addToFleet(FleetSide.ENEMY, "scarab_barrage", FleetMemberType.SHIP, "BRS Beetle", false);
        api.addToFleet(FleetSide.ENEMY, "scarab_barrage", FleetMemberType.SHIP, "BRS Roach", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_mantis_attack", FleetMemberType.SHIP, "BRS Scorpion", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_mantis_strike", FleetMemberType.SHIP, "BRS Manta", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_silverfish_b_standard", FleetMemberType.SHIP, "BRS Ladybug", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_silverfish_b_standard", FleetMemberType.SHIP, "BRS Firefly", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_robberfly_barrage", FleetMemberType.SHIP, "BRS Alarm", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_robberfly_barrage", FleetMemberType.SHIP, "BRS Warning", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_robberfly_strike", FleetMemberType.SHIP, "BRS Siren", false);
        api.addToFleet(FleetSide.ENEMY, "brdy_robberfly_strike", FleetMemberType.SHIP, "BRS Klaxon", false);

        float width = 13000f;
        float height = 13000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        for (int i = 0; i < 36; i++) {
            Vector2f loc = MathUtils.getPointOnCircumference(new Vector2f(0f, height * -0.25f), width / 2f, 360f / 36f *
                                                             i);
            float radius = 3500f + (float) Math.random() * 500f;
            api.addNebula(loc.x, loc.y, radius);
        }

        api.addNebula(-width / 2f, height / 2f, height / 4f);
        api.addNebula(width / 2f, height / 2f, height / 4f);
        api.addNebula(0f, height / 2f, height / 4f);

        for (int i = 0; i < 6; i++) {
            float x = (float) Math.random() * width / 2 + width / 4;
            float y = (float) Math.random() * height / 2;
            float radius = 100f + (float) Math.random() * 400f;
            api.addNebula(x, y, radius);
        }

        api.addObjective(width * 0.04f, height * -0.3f, "sensor_array");
        api.addObjective(width * -0.04f, height * -0.3f, "sensor_array");
        api.addObjective(width * 0f, height * -0.25f, "sensor_array");
        api.addObjective(width * 0f, height * 0.35f, "nav_buoy");
    }
}
